<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Department extends Model 
{

    protected $table = 'departments';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name');

    public function employees()
    {
        return $this->belongsToMany('App\Model\Employee');
    }

    public function posisitions()
    {
        return $this->hasMany('App\Model\Posititon');
    }

}